%define module_name PDL-NDBin
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Carp.pm) perl(Class/Load.pm) perl(Config/General.pm) perl(Data/Dumper.pm) perl(Data/Section.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getopt/Long/Descriptive.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Log/Any.pm) perl(Log/Any/App.pm) perl(Math/Histogram.pm) perl(Math/Round.pm) perl(Module/Pluggable.pm) perl(PDL.pm) perl(PDL/Basic.pm) perl(PDL/Core.pm) perl(PDL/Core/Dev.pm) perl(PDL/Lite.pm) perl(PDL/Types.pm) perl(POSIX.pm) perl(Params/Validate.pm) perl(Path/Class.pm) perl(Pod/Coverage/TrustPod.pm) perl(Term/ProgressBar/Simple.pm) perl(Test/CPAN/Changes.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/PDL.pm) perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm) perl(Test/Version.pm) perl(Text/TabularDisplay.pm) perl(UUID/Tiny.pm) perl(XSLoader.pm) perl(integer.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.028
Release: alt1
Summary: Multidimensional binning & histogramming
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/PDL-NDBin

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz

%description
In scientific (and other) applications, it is frequently necessary to classify
a series of values in a number of bins. For instance, particles may be
classified according to particle size in a number of bins of, say, 0.01 mm
wide, yielding a histogram. Or, to take an example from my own work: satellite
measurements taken all over the globe must often be classified in
latitude/longitude boxes for further processing.

the PDL manpage has a dedicated function to make histograms, hist(). To create a
histogram of particle size from 0 mm to 10 mm, in bins of 0.1 mm, you would
write:

_my $histogram = hist $particles, 0, 10, 0.1;

This will count the number of particles in every bin, yielding the 100 counts
that form the histogram. But what if you wanted to perform other computations
on the values in the bins? It is actually not that difficult to perform the
binning by hand. The key is to associate a bin number with every data value.
With fixed-size bins of 0.1 mm wide, that is accomplished with

_my $bin_numbers = PDL::indx( $particles/0.1 );

(Note that the formulation above does not take care of data beyond 10 mm, but
PDL::NDBin does.) We now have two arrays of data: the actual particle sizes in
$particles, and the bin numbers associated with every data value in
$bin_numbers. The histogram could now be produced with the following loop, $N
being 100:

_my $histogram = zeroes( indx, $N );
_for my $bin ( 0 .. $N-1 ) {
__my $want = which( $bin_numbers == $bin );
__$histogram->set( $bin, $want->nelem );
_}

But, once we have the indices of the data values corresponding to any bin, it
is a small matter to extend the loop to actually extract the data values in the
bin. A user-supplied subroutine can then be invoked on the values in every bin:

_my $output = zeroes( indx, $N )->setbadif( 1 );
_for my $bin ( 0 .. $N-1 ) {
__my $want = which( $bin_numbers == $bin );
__my $selection = $particles->index( $want );
__my $value = eval { $coderef->( $selection ) };
__if( defined $value ) { $output->set( $bin, $value ) }
_}

...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_archlib/P*
%perl_vendor_autolib/*

%changelog
