# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(PDL.pm)
# END SourceDeps(oneline)
%define module_name PDLDM-Rank
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2015.071601
Release: alt1
Summary: Calculates and finds tied ranks of a PDL data matrix
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MB/MBTLFDO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PDLDM::Rank finds the tied rank values of a given PDL.
In the data PDL, the raws should represent the data instances and colomns should represent the attributes.

TiedRank

This returns two PDLs each with the same size as the imput PDL.
The first variable contains the tied rank values.
The second variable contains the number of instances that share the same value.
TiedRank function should produce the same results as the MATLAB tiedrank function.

EstimateTiedRank

In some cases data are divided into two parts, training and testing (or evaluation).
Tied ranks are first evaluated for the training data.
It may be ineffient to re-evaluate the tied ranks of both training and testing data together.

EstimateTiedRank finds the lowest nearest rank for the test data.
It needs three PDL inputs: test data, training data and tied ranks of the training data respectively.
Tied ranks of the training data is the first variable retuned by the TiedRank function.

EstimateTiedRank returns two PDL varibles each of the same size as the test data PDL.
The first varible contains the lowest nearest ranks from the tied ranks of the training data.
The second variable contains whether the value is unique, ie. to be unique it should not exist in the training dataset in the corresponding attribute.

EstimateTiedRankWithDups

This produces similar functionality to the EstimateTiedRank.
However additionally it needs number of duplicates as returned by TiedRank.
It retunes the duplicate count in the traning data instead of the uniqueness.
Therefore, if a value in the second retuned parameter (duplicate count) is zero, the corresponding value in the test/evaluation data is unique.

UniqueRank
This function works with similar input and output parameters as the TiedRank function.
However, it produces ranking without leaving gaps for duplicates.
For example, [ 1 4 4 6 8 8 8 9] given [1 2 2 3 4 4 4 5] ranks.

EstimateUniqueRankWithDups

This performs a similar fucntion as EstimateTiedRankWithDups, but wi...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
