%define module_name PDLx-Mask
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/GUID.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/ProtectedAttributes.pm) perl(PDL/Core.pm) perl(PDL/Lite.pm) perl(PDLx/DetachedObject.pm) perl(Package/Stash.pm) perl(Params/Check.pm) perl(Ref/Util.pm) perl(Safe/Isa.pm) perl(Scalar/Util.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(Test2/Tools/PDL.pm) perl(Test2/V0.pm) perl(Try/Tiny.pm) perl(namespace/clean.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Mask multiple piddles with automatic two way feedback
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Typically the PDL manpage uses bad values to mark elements in a piddle which
contain invalid data.  When multiple piddles should have the same elements
marked as invalid, a separate *mask* piddle (whose values are true for valid data
and false otherwise) is often used.

PDLx::Mask in concert with the PDLx::MaskedData manpage simplifies the management of
mutiple piddles sharing the same mask.  PDLx::Mask is the shared mask,
and PDLx::MaskedData is a specialized piddle which will dynamically respond
to changes in the mask, so that they are always up-to-date.

Additionally, invalid elements in the data piddles may automatically
be added to the shared mask, so that there is a consistent view of
valid elements across all piddles.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes LICENSE CONTRIBUTING.md
%perl_vendor_privlib/P*

%changelog
