%define module_name PEF-Front
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cache/FastMmap.pm) perl(Carp.pm) perl(DBD/Pg.pm) perl(DBIx/Connector.pm) perl(Data/Dumper.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Slurp.pm) perl(FindBin.pm) perl(GD/SecurityImage.pm) perl(GDBM_File.pm) perl(Geo/IPfree.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Locale/PO.pm) perl(MLDBM.pm) perl(MLDBM/Sync.pm) perl(Math/Random/Secure.pm) perl(POSIX.pm) perl(Regexp/Common.pm) perl(SQL/Abstract.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Storable.pm) perl(Sub/Name.pm) perl(Template/Alloy.pm) perl(Test/More.pm) perl(Time/Duration/Parse.pm) perl(Time/HiRes.pm) perl(URI.pm)
BuildRequires: perl(URI/Escape.pm) perl(XML/Simple.pm) perl(YAML/XS.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.26
Release: alt1
Summary: Perl Effective Web Framework
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AN/ANTONPETR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PEF::Front is a Perl web framework with following features.

=over

=item Easy in development

You just write API of your application and it's automatically exposed as AJAX
or data retrieving methods in your templates. HTML templates can be programmed
separately.

=item Fast and versatile template engine

HTML templates can be programmed by other people who know nothing about Perl.

=item Explicit model methods description

Your API calls are described in YAML files. There're can be set default 
values, complex parameter checks, input parameter filters, output filters
and other things.

HTML/AJAX developer can look into these YAML files to understand backend API.

=item Safe

Thanks very comprehensive parameter checks, passed into handler request is
already checked and filtered, you don't need to make additional validation.

=item Flexible rules

Different output filters can be applied to the same data to get different 
data representation. Input data can be obtained automatically from session,
headers, cookies, form and other sources. Results from handlers can set or 
unset headers or cookies. All this is described in YAML and all these 
rules are compiled into native Perl code.

=item Routing

Request routing is very powerful and effective. Your routing rules are 
compiled into native Perl code.

=item Highly configurable

There're many configurable parameters and functions. They have some sensible
defaults that you have to configure only small part of them. It's very easy
to configure them in your own *::AppFrontConfig module. 

=item PSGI

PSGI is very effective protocol for passing incoming requests into 
application. You can use PEF::Front with any PSGI-server. 
I use uwsgi. 
It is also very wise to have some reverse-proxy server in front of 
PSGI-server for static content. I use Nginx.

=item More productive out of the box

PEF::Front has many components that a really useful for typical web 
applications:

=over

=item Sessions

Session data can be automatically loaded during request validation.

=...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod LICENSE Changes
%perl_vendor_privlib/P*

%changelog
