%define module_name PGObject-Util-AsyncPool
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Pg.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: An Async Connection Pooler for PGObject
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EI/EINHVERFR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a basic, simple async connection pool PostgreSQL applications.

It can be used with or without the rest of the PGObject framework.

    my $pool = PGObject::Util::AsyncPool->new($connstring, 
                                              $username, 
                                              $password, 
                                              {RaiseError => 0},
                                              {pollfreq => 5, maxconns => 5},
                                             );
    my $callback = sub { my $sth = shift; say STDERR $sth->rows; };

    for my $query (@queries){
        $pool->run($query, $callback);
    }
    $pool->poll;
    ...
    $pool->poll_loop; # blocks until all queries done

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_privlib/P*

%changelog
