%define module_name PICA-Data
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Encode.pm) perl(Exporter.pm) perl(File/Temp.pm) perl(HTTP/Tiny.pm) perl(Hash/MultiValue.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Term/ANSIColor.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Test/XML.pm) perl(Text/Abbrev.pm) perl(XML/LibXML.pm) perl(XML/Writer.pm) perl(YAML/Tiny.pm) perl(charnames.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.12
Release: alt1
Summary: PICA record processing
Group: Development/Perl
License: perl
URL: https://github.com/gbv/PICA-Data

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VO/VOJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PICA::Data provides methods, classes, and functions to process PICA+ records
in Perl.

PICA+ is the internal data format of the Local Library System (LBS) and the
Central Library System (CBS) of OCLC, formerly PICA. Similar library formats
are the MAchine Readable Cataloging format (MARC) and the Maschinelles
Austauschformat fuer Bibliotheken (MAB). In addition to PICA+ in CBS there is
the cataloging format Pica3 which can losslessly be convert to PICA+ and vice
versa.

Records in PICA::Data are encoded either as as array of arrays, the inner
arrays representing PICA fields, or as an object with two fields, `_id' and
`record', the latter holding the record as array of arrays, and the former
holding the record identifier, stored in field `003@', subfield `0'. For
instance a minimal record with just one field `003@':

    {
      _id    => '12345X',
      record => [
        [ '003@', undef, '0' => '12345X' ]
      ]
    }

or in short form:

    [ [ '003@', undef, '0' => '12345X' ] ]

PICA path expressions can be used to facilitate processing PICA+ records.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/P*
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
