# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(POE.pm) perl(Symbol.pm) perl(Test/More.pm) perl(XML/Atom/Feed.pm) perl(POE/Component/Client/HTTP.pm)
# END SourceDeps(oneline)
%define module_version 1.0
%define module_name POE-Component-AtomAggregator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Watch Muliple Atom Feeds for New Headlines
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/X/XA/XANTUS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
#!/usr/bin/perl.    use strict;
    use warnings;
    use POE qw( Component::AtomAggregator );

    my @feeds = (
        {   url   => "http://xantus.vox.com/library/posts/atom.xml",
            name  => "xantus",
            delay => 600,
        },
        {   url   => "http://www.vox.com/explore/posts/atom.xml",
            name  => "vox",
            delay => 60,
        },
    );

    POE::Session->create(
        inline_states => {
            _start      => \&init_session,
            handle_feed => \&handle_feed,
        },
    );

    $poe_kernel->run();

    sub init_session {
        my ( $kernel, $heap, $session ) = @_[ KERNEL, HEAP, SESSION ];
        $heap->{atomagg} = POE::Component::AtomAggregator->new(
            alias    => 'atomagg',
            debug    => 1,
            callback => $session->postback('handle_feed'),
            tmpdir   => '/tmp',        # optional caching 
        );
        $kernel->post( 'atomagg', 'add_feed', $_ ) for @feeds;
    }

    sub handle_feed {
        my ( $kernel, $feed ) = ( $_[KERNEL], $_[ARG1]->[0] );
        for my $entry ( $feed->late_breaking_news ) {
        
            # this is where this module differs from RSSAggregator!
            
            # do stuff with the XML::Atom::Entry object
            print $entry->title . "\n";
        }
    }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/P*

%changelog
