# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(FileHandle.pm) perl(Mail/Internet.pm) perl(POE/Component/SSLify.pm) perl(Socket.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    POE-Component-Client-NNTP
%define upstream_version 2.22

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Importable constants for POE::Component::Client::NNTP plugins
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/POE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(POE.pm)
BuildRequires: perl(POE/Component/Pluggable.pm)
BuildRequires: perl(POE/Component/Pluggable/Constants.pm)
BuildRequires: perl(POE/Driver/SysRW.pm)
BuildRequires: perl(POE/Filter/Line.pm)
BuildRequires: perl(POE/Wheel/ReadWrite.pm)
BuildRequires: perl(POE/Wheel/SocketFactory.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/POE/Server/TCP.pm)
BuildArch: noarch
Source44: import.info

%description
POE::Component::Client::NNTP is a POE component that provides non-blocking
NNTP access to other components and sessions. NNTP is described in RFC 3977
the http://www.faqs.org/rfcs/rfc3977.html manpage, please read it before
doing anything else.

In your component or session, you spawn a NNTP client component, assign it
an alias, and then send it a 'register' event to start receiving responses
from the component.

The component takes commands in the form of events and returns the salient
responses from the NNTP server.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README LICENSE Changes META.yml META.json examples
%perl_vendor_privlib/*




%changelog
