%define module_name POE-Component-Client-WebSocket
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(MIME/Base64.pm) perl(POE/Driver/SysRW.pm) perl(POE/Filter/SSL.pm) perl(POE/Filter/Stackable.pm) perl(POE/Filter/Stream.pm) perl(POE/Session.pm) perl(POE/Wheel/ReadWrite.pm) perl(POE/Wheel/SocketFactory.pm) perl(Protocol/WebSocket/Frame.pm) perl(Test/More.pm) perl(URI/Split.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.34
Release: alt1
Summary: A simplistic websocket client for use in POE applications.
Group: Development/Perl
License: perl
URL: https://github.com/PaulGWebster/POE-Component-Client-Websocket

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAEMON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
#!/usr/bin/env perl

    use warnings;
    use strict;

    use POE qw(Component::Client::WebSocket);

    POE::Session->create(
        inline_states => {
            _start => sub {
                my $ws = POE::Component::Client::WebSocket->new('wss://echo.websocket.org');
                $ws->handler('connected','connected');
                $ws->connect;

                $_[HEAP]->{ws} = $ws;

                $_[KERNEL]->yield("next")
            },
            next   => sub {
                $_[KERNEL]->delay(next => 1);
            },
            websocket_read => sub {
                my ($kernel,$read) = @_[KERNEL,ARG0];

                print "Read: $read\n";
           },
           websocket_disconnected => sub {
                warn "Disconnected";
           },
           connected => sub {
                my $req = $_[ARG0];
           },
           websocket_handshake => sub {
                my $res = $_[ARG0];

                $_[KERNEL]->post( $_[SENDER]->ID, 'send', 1234 );

                $_[HEAP]->{ws}->send(5678);
           },
        },
    );

    POE::Kernel->run();
    exit;
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/P*

%changelog
