Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-POE-Component-DBIAgent
Version:        0.26
Release:        alt2_45
Summary:        POE Component for running asynchronous DBI calls
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/POE-Component-DBIAgent
Source0:        https://cpan.metacpan.org/authors/id/R/RD/RDB/POE-Component-DBIAgent-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/MethodMaker.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(POE.pm)
BuildRequires:  perl(POE/Filter/Reference.pm)
BuildRequires:  perl(POE/Session.pm)
BuildRequires:  perl(POE/Wheel/Run.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(vars.pm)
# Tests only
Requires:       perl(POE.pm) >= 0.170
Requires:       perl(Time/HiRes.pm)


Source44: import.info
%filter_from_requires /^perl(POE.pm)/d

%description
DBIAgent is your answer to non-blocking DBI in POE.

DBIAgent forks off a configurable number of helper processes for
running DBI queries.  The states that depend on the output of the
queries only get called when there is data for them to process.  No
more agonizing about query optimization in terms of milliseconds
because the rest of your program will suffer.  Leave that to the
operating system!  POE is designed for doing a lot of things
concurrently.  Waiting isn't doing, it's waiting... :-)

%prep
%setup -q -n POE-Component-DBIAgent-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
