# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(FindBin.pm) perl(Scalar/Util.pm) perl(Time/HiRes.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    POE-Component-Sequence
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Adds special features to nested sequences
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/POE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/MethodMaker.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(POE.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
A Sequence is a series of code blocks (actions) that are executed (handled)
within the same context, in series. Each action has access to the sequence
object, can pause it, finish the sequence, add additional actions to be
performed later, or store variables in the context (the heap).

If we had the following action in the above example sequence:

    sub {
        my $sequence = shift;
        $sequence->pause;
        ...
    }

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CHANGES META.json META.yml  README SIGNATURE
%perl_vendor_privlib/*

%changelog
