Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(POE/Component/Server/SimpleHTTP/PreFork.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run optional test
%bcond_without perl_POE_Component_Server_SimpleHTTP_enables_optional_test

Name:           perl-POE-Component-Server-SimpleHTTP
Version:        2.30
Release:        alt1_4
Summary:        Serve HTTP requests in POE
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/POE-Component-Server-SimpleHTTP
Source0:        https://cpan.metacpan.org/authors/id/B/BI/BINGOS/POE-Component-Server-SimpleHTTP-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(bytes.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(HTTP/Date.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Moose/Object.pm)
BuildRequires:  perl(Moose/Util/TypeConstraints.pm)
BuildRequires:  perl(MooseX/POE.pm)
BuildRequires:  perl(POE.pm)
BuildRequires:  perl(POE/Component/SSLify.pm)
BuildRequires:  perl(POE/Filter/HTTPD.pm)
BuildRequires:  perl(POE/Filter/Stream.pm)
BuildRequires:  perl(POE/Wheel/ReadWrite.pm)
BuildRequires:  perl(POE/Wheel/SocketFactory.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(Sys/Hostname.pm)
# Tests only
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(POE/Filter/HTTP/Parser.pm)
BuildRequires:  perl(POE/Kernel.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/POE/Client/TCP.pm)
%if %{with perl_POE_Component_Server_SimpleHTTP_enables_optional_test}
# Optional tests only
BuildRequires:  perl(POE/Component/Client/HTTP.pm)
%endif
Requires:       perl(HTTP/Request.pm)
Requires:       perl(Moose.pm) >= 0.900
Requires:       perl(Moose/Object.pm)
Requires:       perl(MooseX/POE.pm) >= 0.205
Requires:       perl(POE.pm) >= 1.0
Requires:     perl(POE/Component/SSLify.pm) >= 0.040
Requires:       perl(Storable.pm)
Requires:       perl(Sys/Hostname.pm)


# Remove underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Moose\|MooseX.POE\|POE\|POE.Filter.HTTP.Parser\|Test.More\|Test.POE.Client.TCP\).pm)/d

%description
This module makes serving up HTTP requests a breeze in POE.

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(POE.pm) >= 1.0
%if %{with perl_POE_Component_Server_SimpleHTTP_enables_optional_test}
Requires:       perl(POE/Component/Client/HTTP.pm) >= 0.820
%endif
Requires:       perl(POE/Filter/HTTP/Parser.pm) >= 1.060
Requires:       perl(POE/Filter/Stream.pm)
Requires:       perl(Test/More.pm) >= 0.470
Requires:       perl(Test/POE/Client/TCP.pm) >= 1.240

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n POE-Component-Server-SimpleHTTP-%{version}

perl -i -pe 's/\r$//g' examples/*
# Remove unused tests
for F in \
    t/author-pod-coverage.t t/author-pod-syntax.t \
%if !%{with perl_POE_Component_Server_SimpleHTTP_enables_optional_test}
    t/06_stream.t \
%endif
; do
    rm "$F"
    perl -i -ne 'print $_ unless m{\A\Q'"$F"'\E}' MANIFEST
done
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
yes | perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
unset AUTHOR_TESTING
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
unset AUTHOR_TESTING
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc README Changes Changes.old examples
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
