# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    POE-Component-SmokeBox-Dists
%define upstream_version 1.10

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Search for CPAN distributions by cpanid or distribution name
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/POE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/DistnameInfo.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Fetch.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IO/Zlib.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(POE.pm)
BuildRequires: perl(Sort/Versions.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(URI.pm)
BuildArch:  noarch
Source44: import.info

%description
POE::Component::SmokeBox::Dists is a the POE manpage component that
provides non-blocking CPAN distribution searches. It is a wrapper around
the File::Fetch manpage for '02packages.details.txt.gz' file retrieval, the
IO::Zlib manpage for extraction and the CPAN::DistnameInfo manpage for
parsing the packages data.

Given either author ( ie. CPAN ID ) or distribution search criteria,
expressed as a regular expression, it will return to a requesting session
all the CPAN distributions that match that pattern.

The component will retrieve the '02packages.details.txt.gz' file to the
'.smokebox' directory. If that file already exists, a newer version will
only be retrieved if the file is older than 6 hours. Specifying the 'force'
parameter overrides this behaviour.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%{perl_vendor_privlib}/*

%changelog
