%define module_name POE-Component-WheelRun-Pool
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Const/Fast.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Load.pm) perl(POE.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: POE::Wheel::Run worker pool
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLHOTSKY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides a pool wrapper around POE::Wheel::Run to allow for large worker pools that are automatically replenished.
POE::Component::WheelRun::Pool uses STDIN, STDOUT, and STDERR for communication between the parent session and the worker children.

    my $worker_pool_id = POE::Component::WheelRun::Pool->spawn(
        Alias            => 'pool',             # Default
        Program          => \&run_analysis,     # Required
        PoolSize         => 4,                  # Default
        MaxTasksPerChild => 1000,               # Default '0' = unlimited
        MaxTimePerChild  => 3600,               # Default '0' = unlimited
        Splay            => 0.1,                # Default
        # Any Options from POE::Wheel::Run
        User     => 'bob',
        Group    => 'nobody',
        Priority => 5,
    );

    my $main = POE::Session->create(inline_states => {
        new_event => sub { $poe_kernel->post( pool => dispatch => @_[ARG0] ) },
    });

This will create a pool of 4 workers with the run_analyze function as the entry point to the pool::dispatch event.  Child processes
should monitor STDIN for availability as the first thing attempted by the parent is an EOF on the STDIN of the child to let it know it should
go away.  Failing this, a kill() is called which is SIGINT by default.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.mkdn LICENSE
%perl_vendor_privlib/P*

%changelog
