# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POE/Driver/SysRW.pm) perl(POE/Filter/Reference.pm) perl(Socket.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(YAML.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name POE-Event-Message
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: A generic messaging protocol
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CC/CCOBB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This class is a starting point for creating a generic application
messaging protocol. The intent is for this to be used as a foundation
when building network and/or event-driven applications such as Web 
services.

Features of POE::Event::Message include the following.

=over

=item *

Messages of this class have flexible routing capabilities 
that work both inside and outside POE-based applications. 

=item *

A 'local' message routing mechanism is designed to be 
plug-compatible with POE's existing 'postback' mechanism. 
This is referred to as a 'routeback' mechanism in this class. 

=item *

A 'remote' message routing mechanism can be used by message-based
client scripts, or perhaps as a simple alternative to the 'IKC' 
(Inter Kernel Communication) mechanism.

=item *

Messages are delivered based on the type of the destination. 
A 'local' routing will trigger a POE 'post' or 'call' event, 
while a 'remote' routing invokes a socket connection to a 
particular host and port. 

=item *

In addition, this class has the ability to introduce 
multiple 'forward' and/or 'reverse' routing to multiple
event and/or remote host destinations. This allows for
temporary interruption of normal message flow, without
any of the original participants (events or whatever)
knowing or caring.

=item *

Messages can also be sent through a file handle, such as 
from a non-POE child to a POE-based parent process.

=item *

Messages can contain almost anything including binary data
and complex Perl data structures.

=back

Messages are created using the 'new()' method or the 
envelope()' or package()' methods.
A message body can be add during creation or afterward using
the body()' method.

Responses to messages can be created using the same message creation
methods but with the originating message as an added argument.
This way, the unique message identifier on the originating message
is added to the reply as an 'in reply to' identifier. This allows
correlating originating messages with their replies, if necessary.

Message routing is flexible and can be either 'local' or 'remote'.
The 'addRouteTo()' and 'addRouteBack()' 
methods are used to add 'local' routing to POE-based event services.
This type of routing triggers POE's internal 'post' or 'call' mechanism
for asynchronous or synchronous message delivery.

The 'addRemoteRouteTo()' and 
'addRemoteRouteBack()' methods are used to
add 'remote' routing of messages to services on remote hosts.
This type of routing triggers 'read()' and 'write()'
methods to send and receive messages across network sockets. Remote
delivery can be either synchronous (expecting an immediate response 
message) or asynchronous (where response is only a 'delivery status' of 
either successful or unsuccessful).

Multiple forward and/or reverse routing destinations can be added to a 
given message. Additional local and/or remote routing destinations can 
be added at any time during processing. This is useful, for example, to 
interrupt the original message flow, as none of the original participants 
need be aware of any interruption(s).

When adding a routing destination, a list of 'StateArgs' can be 
included. These will be available to the receiving event method when the 
message is delivered (just like POE's postback/callback StateArgs list).

The 'route()' method is used to actually route messages
to their destinations. When routing messages, a list of 'RouteArgs' 
can be included. These will be available to the receiving event method 
when the message is delivered (just like POE's postback/callback 
AdditionalArgs list). *Note that the routed message object will be
delivered as the first element of the 'RouteArgs' list reference*.

This class does not explicitly use POE. This allows
'light weight' scripts that run outside the full POE environment to
use this messaging protocol. When POE is not used, only the 'remote'
mechanism is available. This is because the 'post' and 'call' routing 
semantics rely on the POE kernel. 

Note also that 'local' routing destinations using 'post' and 'call' can
be created outside of POE. If, for example, messages are sent via a 'remote 
routing' to a POE-based process, that process can then 'route()' 
messages using 'post' and/or 'call' to the specified event service 
destination(s).

When running outside of the POE environment either explicitly add a 
'remote' routing -or- use the routeIsRemote() method 
(as shown in the Synopsis section, above) to determine if 
the route() method can be called on a given message object.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README TODO Changes
%perl_vendor_privlib/P*

%changelog
