BuildRequires: xvfb-run
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Locale/Msgfmt.pm) perl(Module/Build.pm) perl(Padre.pm) perl(Test/More.pm) perl(Wx/Perl/DataWalker.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_name Padre-Plugin-DataWalker
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Simple Perl data structure browser Padre
Group: Development/Perl
License: perl
URL: http://padre.perlide.org

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AZ/AZAWAWI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin uses the the Wx::Perl::DataWalker manpage module to
provide facilities for interactively browsing Perl data structures.

At this time, the plugin offers several menu entries
in Padre's *Plugins* menu:

=over 2

=item Browse YAML dump file

If you dump (almost) any data structure from a running program into
a YAML file, you can use this to open the dump and browse
it within Padre. Dump a data structure like this:

  use YAML::XS; YAML::XS::Dump(...YourDataStructure...);

This menu entry will show a file-open dialog and let you select the YAML
file to load.

Let me know if you need any other input format (like Storable's nstore).

=item Browse current document object

Opens the data structure browser on the current document object.

Like all following menu entries, this is mostly useful for the Padre developers.

=item Browse Padre IDE object

Opens the Padre main IDE object in the data structure browser. Useful for debugging Padre.

=item Browse Padre main symbol table

Opens the `%%main::' symbol table of Padre in the data structure browser.
Certainly only useful for debugging Padre.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%{expand:%%global __find_requires xvfb-run -a %__find_requires}

%files
%doc README LICENSE Changes
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*

%changelog
