# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(BSD/Resource.pm) perl(CPP/catch/test.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/ParseXS.pm) perl(FindBin.pm) perl(Panda/Install.pm) perl(Panda/Lib.pm) perl(Panda/XS.pm) perl(Test/Deep.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define module_name Panda-Config-Perl
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.7
Release: alt4
Summary: Convenient and flexible config loader in perl format.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SY/SYBER/%{module_name}-%{version}.tar.gz

%description
This module provides you with powerful config system.

It allows you to:

=over

=item

Write variable definitions in perl language.
You do not need to define a huge hash in config file - you just write separate variables.

    $var = 'value';
    $arr = [1..100];
    
These variables are accessible in config hash by name.

    $cfg = Panda::Config::Perl->process(...);
    say length @{$cfg->{arr}};

=item

Split your configs into separate files and include them.

    #include "something.conf"
    #include $filename . ".conf"
    if ($something) {
        #include "something.conf"
    }

=item

Access variables between configs.

    $myvar = $NS::var + 10; # access variable 'var' from root namespace

=item

Overwrite variables from another config file. Just change their values.
    
    $NS::var++;
    
If both destination and source are hashrefs, they are merged

    $NS::somehash = {a => 1};
    $NS::somehash = {key => $NS::somehash->{a}};
    ...
    exists $cfg->{somehash}{a}; # true
    exists $cfg->{somehash}{key}; # true
   

=item

Use namespaces.

    #namespace jopa
    $var = 10;
    
Everything under namespace jopa goes to $cfg->{jopa}{...}

=back

This is very useful for big projects where your config might grow over 100kb.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_archlib/P*
%perl_vendor_autolib/*

%changelog
