# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor/Fast.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Parallel-Batch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Run a large number of similar processes using
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SACAVILIA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Parallel::Batch solves a common problem allowing modern multi-CPU
computers to be used efficiently: you have a large number of
independent pieces of data that all need to be processed somehow, and
can run several of these processes at the same time.

There are a few trivial ways to execute a large number of jobs. You
could run the entire set serially, but this will not use all the
available processing speed. You could also create *n* processes at
once to run all jobs simultaneously, but this tends to quickly exhast
other resources like memory and I/O bandwidth, making the entire
process slower. Or you could divide the set into *m* equally-sized
groups and have each processor run its subset serially, but this will
usually waste time at the end if some jobs take longer than others to
finish.

This module works by calling `fork()' to create a new process,
invoking a user-specified function on the next piece of data within
this process, and returning once all data has been thusly processed
and all processes exited. It also keeps track of the total number of
jobs in progress, and will keep this under a set limit by delaying new
forks until existing processes terminate.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
