# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(IO/All.pm) perl(Mail/Sendmail.pm) perl(Module/Build.pm) perl(Object/InsideOut.pm) perl(Proc/ProcessTable.pm) perl(Sys/Hostname.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(overload.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define module_version 0.9.3
%define module_name Parallel-Mpich-MPD
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9.3
Release: alt1
Summary: Mpich MPD wrapper
Group: Development/Perl
License: lgpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AL/ALEXMASS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This *Parallel::Mpich::MPD*, a wrapper module for MPICH2 Process Management toolkit from http://www-unix.mcs.anl.gov/mpi/mpich2/. 
The wrapper include the following tools: basic configuration, mpdcheck, mpdboot, mpdcleanup, mpdtrace, 
mpdringtest, mpdallexit, mpiexec, mpdsigjob and mpdlistjobs.

=over 4

=item boot(hosts => @hosts, machinesfile => $machines, checkOnly => 1|0, output => \$output)
  
starts a set of mpd's on a list of machines. boot try to verify that the hosts in the host 
file are up before attempting start mpds on any of them. 
  
=item rebootHost(host => $hostname)

restart mpd on the specified host. rebootHost will kill old mpds before restarting a new one. 
The killed MPDS are filtered by specific port and host.

=item check(machinesfile => $file, hostsup => \%%hosts, hostsdown => \%%hostsdown , reboot => 1)

Check if MPD master and nodes are well up. If MPD master is down it try to ping and ssh machines.   
If you use the option reboot, check will try to restart  mpd on specified machines or to reboot the master. 
  
=item info( )

return an %%info of the master with the following keys (master, hostname, port)
  
=item validateMachinesfile(machinefiles => $filename)

check with mpdtrace if all machines specified by filename are up. If not, a temporary file is 
created with the resized machinesfile 

=item shutdown( )

causes all mpds in the ring to exit

=item createJob({cmd => $cmd , machinesfile=> $filename, [params => $params], [ncpu => $ncpu], [alias => $alias])
 
start a new job with the command line and his params. It return true if ok.
  WARNING ncpu could be redefined if mpdtrace return ao small hosts list
     
Example:
  
  Parallel::Mpich::MPD::createJob(cmd => $cmd, params => $parms, ncpu => '3', alias => 'job1');

=item listJobs([mpdlistjobs_contents=>$str])

Return an Parallel::Mpich::MPD::Job array for all available jobs
If mpdlistjobs_contents argument is present, the code will not call mpdlistjobs but 
take the parameter as a fake results of this command

=item findJob([%%criteria][, return=>(getone|host2pidlist))

find a job from crtiteria. It return a Job instance or undef for no match

=over 4

=item Criteria can be of

=item username=>'somename' or username=>\@arrayOfNames

=item jobid=>'somename' or jobid=>\@arrayOfJobid

=item jobalias=>'somename' or jobalias=>\@arrayOfJobalias

To set an array of names;

  $criteria{psid} [&& $criteria{rank}]  You can select psid from the specified rank.
  $criteria{reloadlist}  force the call of listjobs

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%files scripts
%_bindir/*

%changelog
