Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Params-CallbackRequest
Version:        1.20
Release:        alt2_29
Summary:        Functional and object-oriented callback architecture
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Params-CallbackRequest
Source0:        https://cpan.metacpan.org/authors/id/D/DW/DWHEELER/Params-CallbackRequest-%{version}.tar.gz
BuildArch:      noarch
# Module Build
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Module/Build.pm)
# Module Runtime
BuildRequires:  perl(Attribute/Handlers.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Class/ISA.pm)
BuildRequires:  perl(Exception/Class.pm)
BuildRequires:  perl(Params/Validate.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# Test Suite
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
# Runtime
Requires:       perl(Attribute/Handlers.pm) >= 0.770
Requires:       perl(Carp.pm)
Requires:       perl(Class/ISA.pm)
Requires:       perl(Exception/Class.pm) >= 1.100
Requires:       perl(Params/Validate.pm) >= 0.590

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Exception.Class\|Params.Validate\).pm)/d

%description
Params::CallbackRequest provides functional and object-oriented callbacks
to method and function parameters. Callbacks may be either code references
provided to the new() constructor, or methods defined in subclasses of
Params::Callback. Callbacks are triggered either for every call to the
Params::CallbackRequest request() method, or by specially named keys in the
parameters to request().

%prep
%setup -q -n Params-CallbackRequest-%{version}

# Avoid spurious warning from Test::Pod
mkdir bin

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT

%check
./Build test

%files
%doc Changes README.md
%{perl_vendor_privlib}/Params/

%changelog
