# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Locale/Maketext/Simple.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Params-Check-Faster
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Faster implementation of Params::Check, a templated based param validation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAMS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Params::Check::Faster is a generic input parsing/checking mechanism.

This module is a faster reimplementation of Params::Check. It should be 100%%
compatible. It might be merged with Params::Check at some point, after its author (kane) has reviewed it and is happy with merging it.

It allows you to validate input via a template. The only requirement
is that the arguments must be named.

Params::Check::Faster can do the following things for you:

=over 4

=item *

Convert all keys to lowercase

=item *

Check if all required arguments have been provided

=item *

Set arguments that have not been provided to the default

=item *

Weed out arguments that are not supported and warn about them to the
user

=item *

Validate the arguments given by the user based on strings, regexes,
lists or even subroutines

=item *

Enforce type integrity if required

=back

Most of Params::Check::Faster's power comes from its template, which we'll
discuss below:
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES
%perl_vendor_privlib/P*

%changelog
