# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp/Assert.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/CheckManifest.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name Params-Check-Item
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: checks the type or value of an item at any point during execution
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SS/SSTEFFL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Params::Check::Items exports a bunch of utility functions for checking the
values of items through Carp::Assert. It is different than other parameter
checking modules since it has low configuration overhead and you are
expected to check one parameter at a time, instead of creating a giant hash
of all the valid values for all the parameters, such as Params::Check.
All exported functions optionally take in a message parameter at the end
that is displayed if Carp::Assert fails. 

If you would like to disable the checks, you must set the environment 
variable PARAMS_CHECK_ITEM_OFF=1. Note that this can be toggled on and
off during runtime.

An example:

    use Params::Check::Item;
    sub myFunc {
      my ($row, $col, $matrix) = @_[0..2];
      checkIndex($row, "row not an index");
      checkIndex($col, "col not an index");
      checkClass($matrix, "My::Matrix::Type", "invalid matrix");
      $matrix->get($row, $col);
    }

%prep
%setup -q -n %{module_name}-%{version}
rm -f t/[0-9][-_]signature.t t/[0-9][0-9][-_]signature.t t/[0-9]signature.t t/[0-9][0-9]signature.t t/signature.t
rm -f t/[0-9][-_]Signature.t t/[0-9][0-9][-_]Signature.t t/[0-9][0-9][0-9][-_]Signature.t t/[0-9]Signature.t t/[0-9][0-9]Signature.t t/[0-9][0-9][0-9]Signature.t t/Signature.t
rm -f t/[0-9][-_]manifest.t t/[0-9][0-9][-_]manifest.t t/[0-9][0-9][0-9][-_]manifest.t t/[0-9]manifest.t t/[0-9][0-9]manifest.t t/[0-9][0-9][0-9]manifest.t t/manifest.t
rm -f t/[0-9][-_]MANIFEST.t t/[0-9][0-9][-_]MANIFEST.t t/[0-9][0-9][0-9][-_]MANIFEST.t t/[0-9]MANIFEST.t t/[0-9][0-9]MANIFEST.t t/[0-9][0-9][0-9]MANIFEST.t t/MANIFEST.t
rm -f t/[0-9][-_]check_manifest.t t/[0-9][0-9][-_]check_manifest.t t/[0-9][0-9][0-9][-_]check_manifest.t t/[0-9]check_manifest.t t/[0-9][0-9]check_manifest.t t/[0-9][0-9][0-9]check_manifest.t t/check_manifest.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README ignore.txt
%perl_vendor_privlib/P*

%changelog
