%define module_version 2.02
%define module_name Paranoid-BerkeleyDB
# BEGIN SourceDeps(oneline):
BuildRequires: perl(BerkeleyDB.pm) perl(Class/EHierarchy.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Paranoid.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.02
Release: alt1
Summary: BerkeleyDB CDS Support for Paranoid
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/CORLISS/%{module_name}/Paranoid-BerkeleyDB-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides an OO/tie-based wrapper for BerkeleyDB CDS
implementations intended for use in tied hashes.

NOTE: This module breaks significantly with previous incarnations of this
module.  The primary differences are as follows:

    Pros
    -------------------------------------------------------------
    * Places no limitations on the developer regarding BerekelyDB
      environment and database options
    * Automatically reuses existing environments for multiple 
      tied hashses
    * Uses Btree databases in lieu of hashes, which tended to 
      have issues when the database size grew too large
    * Has a fully implemented tied hash interface incorporating 
      CDS locks
    * Has pervasive debugging built in using the Paranoid::Debug manpage

    Cons
    -------------------------------------------------------------
    * Is no longer considered fork-safe, attempted accesses will
      case the child process to croak.
    * Uses Btree databases in lieu of hashes, which does add 
      some additional memory overhead
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGELOG README LICENSE
%perl_vendor_privlib/P*

%changelog
