%define module_name Parse-Gnaw
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.601
Release: alt2
Summary: Write extensible, recursive, grammars in
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GS/GSLONDON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Write extensible, recursive, grammars using pure perl code.
Grammar rules are perl arrays. Apply them to whatever parsee you want.
Normal parsees would be strings. Interesting parsees might be a 
three-dimensional array of characters.

_no strict 'vars';
_use Parse::Gnaw;
_use Parse::Gnaw::String;

_rule('SayHello', 'Hello', 'World');
_my $string=Parse::Gnaw::String->New('So Hello World of mine');
_$string->parse('SayHello');

This is the second generation of Parse::Gnaw starting from revision 0.600.
Gen1 stored rules as code references and that prevented recursive calls
within a rule as calling the code ref for the rule would go into an 
infinite loop. Gen2 uses array references to store rule, with the name
of the array reference variable matching the name of the rule.

_our $rulename = [ .... rule content .... ];

It should allow recursive rules, although it will probably get hung
in an infinite loop trying to match a left recursive rule.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
