%define module_name Parse-Lnk
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Math/BigInt.pm) perl(Test/More.pm) perl(bigint.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A cross-platform, depencency free, Windows shortcut (.lnk) meta data parser.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZA/ZARABOZO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module reads Win32 shortcuts (*.lnk files) to obtain the meta data in them.

Its goal is to be able to resolve the path they point to (along with other data),
from any platform/OS, without the need for extra dependencies.

Some examples of usage:

    use Parse::Lnk;

    my $data = Parse::Lnk->from($filename);
    
    # $data is now a hashref if the file was parsed successfully.
    # undef if not.
    
    ##########
    # Or ... #
    ##########
    
    use Parse::Lnk qw(parse_lnk);
    
    my $data = parse_lnk $filename;
    
    # $data is now a hashref if the file was parsed successfully.
    # undef if not.
    
    ##########
    # Or ... #
    ##########
    
    use Parse::Lnk qw(resolve_lnk);
    
    my $path = resolve_lnk $filename;
    
    # $path is now a string with the path the lnk file points to.
    # undef if the lnk file was not parsed successfully.
    
    ###############################################################
    # Or, if you want a little more information/control on errors #
    ###############################################################
    
    use Parse::Lnk;
    
    my $lnk = Parse::Lnk->new;
    
    $lnk->parse($filename) or die $lnk->{error};
    
    # Or:
    
    $lnk->parse($filename);
    
    if ($lnk->{error}) {
        # ... do your own error handling;
    }
    




%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
