%define module_name Parse-Netstat-Colorizer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error/Helper.pm) perl(Net/DNS.pm) perl(Parse/Netstat.pm) perl(Parse/Netstat/Search.pm) perl(Parse/Netstat/Search/Sort.pm) perl(Term/ANSIColor.pm) perl(Text/Table.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Searches and colorizes the output from Parse::Netstat
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Parse::Netstat;
    use Parse::Netstat::Colorizer;
    
    my $pnc = Parse::Netstat::Colorizer->new();
    
    # don't even bother parsing unix sockets... Parse::Netstat::Search, Parse::Netsat::Search::Sort;
    # and this only currently handle non-unix network connections
    my $res = parse_netstat(output => join("", `netstat -n`), tcp=>1, udp=>1, unix=>0,  flavor=>$^O);
    
    # search only for connections to/from specific networks
    my @networks=('192.168.0.0/24', '10.10.10.0/24');
    my $search=$pnc->get_search;
    $search->set_cidrs( \@networks );
    if ( $search->error ){
        warn( 'One of the passed CIDRs is bad' );
    }
    
    # set it to host local sort
    my $sorter=$pnc->get_sort;
    $sorter->set_sort( 'host_l' );

Sorting and searching is handled via the Parse::Netsat::Search manpage and
the Parse::Netstat::Search::Sort manpage. Their objects for tweaking can be
fetched via get_sort and get_search.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/P*

%files scripts
%_bindir/*

%changelog
