%define module_version 0.61
%define module_name Passwd-Keyring-PWSafe3
Serial: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Crypt/PWSafe3.pm) perl(Email/Simple.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/ShareDir.pm) perl(FindBin.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Getopt.pm) perl(Net/IMAP/Simple/SSL.pm) perl(Pod/Readme.pm) perl(Term/ReadKey.pm) perl(Test/Kwalitee.pm) perl(Test/Kwalitee/Extra.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.61
Release: alt1
Summary: Password storage based on Password Safe encrypted files
Group: Development/Perl
License: perl
URL: http://bitbucket.org/Mekk/perl-keyring-pwsafe3

Source0: http://cpan.org.ua/authors/id/M/ME/MEKK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Password Safe implementation of the Passwd::Keyring manpage. Passwords are
stored in the Password Safe (http://passwordsafe.sourceforge.net)
encrypted file.

This module does not require Password Safe to be installed, and can be
used as generic "store many passwords in file encrypted with single
master password" storage. Password Safe GUI, if installed, may help
the user to review, modify, or delete saved passwords.

Note: actual handling of Password Safe format is based on the Crypt::PWSafe3 manpage
module. Passwd::Keyring::PWSafe3 just wraps it into the interface compatible
with other Passwd::Keyring backends.

    use Passwd::Keyring::PWSafe3;

    my $keyring = Passwd::Keyring::PWSafe3->new(
         app=>"blahblah scraper",
         group=>"Johnny web scrapers",
         file=>"/home/joe/secrets.pwsafe3",        # HOME / passwd-keyring.pwsafe3 by default
         master_password=>"very secret password",  # Or callback. See ->new docs below
    );

    my $username = "John";  # or get from .ini, or from .argv...

    my $password = $keyring->get_password($username, "blahblah.com");
    unless( $password ) {
        $password = <somehow interactively prompt for password>;

        # securely save password for future use
        $keyring->set_password($username, $password, "blahblah.com");
    }

    login_somewhere_using($username, $password);
    if( password_was_wrong ) {
        $keyring->clear_password($username, "blahblah.com");
    }

Note: see the Passwd::Keyring::Auto::KeyringAPI manpage for detailed comments
on keyring method semantics (this document is installed with
`Passwd::Keyring::Auto' package).


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*
%changelog
