%define module_name Password-OWASP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/Passphrase.pm) perl(Authen/Passphrase/Argon2.pm) perl(Authen/Passphrase/BlowfishCrypt.pm) perl(Authen/Passphrase/Scrypt.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Import/Into.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(Sub/Override.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Try/Tiny.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: OWASP recommendations for password storage in perl
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WA/WATERKIP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module tries to implement OWASP password
recommendations for safe storage in Perl. In short OWASP recommends the
following:

=over

=item * Don't limit password length or characters

=item * Hash the password before you crypt them

=item * Use either Argon2, PBKDF2, Scrypt or Bcrypt

=back

This module currently supports Argon2, Scrypt and Bcrypt. All implementations
hash the password first with SHA-512. SHA-256 and SHA-1 are also supported.
This allows for storing password which are longer that 72 characters.

The check_password method allows for weaker schemes as the module also allows
for inplace updates on these passwords. Please note that clear text passwords
need to be prepended with `{CLEARTEXT}' in order for the Authen::Passphrase manpage to
do its work.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/P*

%changelog
