%define module_name Password-Policy-Rule-Pwned
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(LWP.pm) perl(LWP/Protocol/https.pm) perl(Password/Policy.pm) perl(String/Multibyte.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Compare text to known pwned passwords list
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HOUSTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Plug this rule into the Password::Policy manpage to
validate potential passwords against the list from
haveibeenpwned.com. It
uses the recommended
range
function to ensure that neither the password nor its full hash is ever
transferred over the wire.

The Password::Policy configuration file should set the "pwned" attribute
to 1 in any policy where this rule should apply. A trivial example of
such a policy might be:

    ---
    default:
        length: 8
        algorithm: "Plaintext"
        pwned: 1

As with all other the Password::Policy::Rule manpage types, this will throw an
exception to indicate an unsafe password. As it relies on a network
service to operate it will also throw an exception if the service is
unavailable for whatever reason. The two exceptions are different and
may be interrogated to determine the difference.

    try {
        $pp->process({ password => $pass });
    } catch {
        if ($_->isa ("Password::Policy::Exception::Pwned")) {
            warn "This password '$pass' is pwned - don't use it";
        } elsif ($_->isa ("Password::Policy::Exception::PwnedError")) {
            warn "Could not check if password is pwned - use at own risk";
        } else {
            warn "Password not pwned but still bad: $_";
        }
        # Other actions
    }

Alternatively the response may be stringified and the messages parsed for
key phrases, although this will be less robust.

    try {
        $pp->process({ password => $pass });
    } catch {
        if (/has been pwned/) {
            warn "This password '$pass' is pwned - don't use it";
        } elsif (/Invalid response/) {
            warn "Could not check if password is pwned - use at own risk";
        } else {
            warn "Password not pwned but still bad: $_";
        }
        # Other actions
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/P*

%changelog
