# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Monkey/Patch/Action.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/CSV.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Patch-DBI-WriteCSV
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Patch DBI to also write CSV while fetching rows
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Patch-DBI-WriteCSV

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package patches the following the DBI manpage methods:

 fetchrow_array
 fetchrow_arrayref
 fetchrow_hashref
 fetchall_arrayref
 fetchall_hashref

to also write CSV while fetching row(s). By default it writes to STDOUT but this
can be customized (see the IMPORTS entry elsewhere in this document).

Compared to solution like the DBIx::CSV manpage, this solution does not introduce new
methods to DBI's database/statement handle, so producing CSV can be easier when
you do not use DBI directly, like when you use the DBIx::Class manpage.

=for Pod::Coverage ^(.+)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*

%changelog
