# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Path-Class-Rule
%define upstream_version 0.018

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    File finder using Path::Class
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Path/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Path/Iterator/Rule.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module iterates over files and directories to identify ones matching a
user-defined set of rules. The API is based heavily on the File::Find::Rule
manpage, but with more explicit distinction between matching rules and
options that influence how directories are searched. A 'Path::Class::Rule'
object is a collection of rules (match criteria) with methods to add
additional criteria. Options that control directory traversal are given as
arguments to the method that generates an iterator.

Here is a summary of features for comparison to other file finding modules:

* *

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
