# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Moose.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Path-Dispatcher
%define upstream_version 1.06

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    All rules must match
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Path/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Any/Moose.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildArch:  noarch
Source44: import.info

%description
We really like the Jifty::Dispatcher manpage and wanted to use it for the
Prophet manpage's command line.

The basic operation is that of dispatch. Dispatch takes a path and a list
of rules, and it returns a list of matches. From there you can "run" the
rules that matched. These phases are distinct so that, if you need to, you
can inspect which rules were matched without ever running their codeblocks.

You want to use the Path::Dispatcher::Declarative manpage which gives you
some sugar inspired by the Jifty::Dispatcher manpage.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml 
%{perl_vendor_privlib}/Path/

%changelog
