# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Path-Extended
%define upstream_version 0.23

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Yet another Path class
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Path/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(ExtUtils/MakeMaker/CPANfile.pm)
BuildRequires: perl(Fcntl.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Copy/Recursive.pm)
BuildRequires: perl(File/Find/Rule.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/stat.pm)
BuildRequires: perl(IO.pm)
BuildRequires: perl(Log/Dump.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Sub/Install.pm)
BuildRequires: perl(Test/Classy.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/UseAllModules.pm)
BuildArch:  noarch
Source44: import.info

%description
This is yet another file/directory handler that does a bit more than the
Path::Class manpage for some parts, and a bit less for other parts. One of
the main difference is the Path::Extended manpage always tries to use
forward slashes when possible, ie. even when you're on the MS Windows, so
that you don't need to care about escaping paths that annoys you from time
to time when you want to apply regexen to a path, especially in file tests
that use 'like' or 'compare'.

Also, the Path::Extended manpage can do some basic file/directory
operations such as copy, move, and rename as well as file I/O stuff like
open, close, and slurp (and some of these may behave differently from the
equivalents of the Path::Class manpage).

On the other hand, the Path::Extended manpage doesn't care (or care little)
about converting foreign path names or ascending/descending path tree.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%{perl_vendor_privlib}/*


%changelog
