Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-Critic-Bangs
Version:        1.12
Release:        alt2_22
Summary:        Collection of handy Perl::Critic policies
License:        Artistic 2.0
URL:            https://metacpan.org/release/Perl-Critic-Bangs
Source0:        https://cpan.metacpan.org/authors/id/P/PE/PETDANCE/Perl-Critic-Bangs-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Perl/Critic.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
BuildRequires:  perl(Readonly.pm)
# Tests only:
BuildRequires:  perl(English.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Perl/Critic/Config.pm)
BuildRequires:  perl(Perl/Critic/PolicyFactory.pm)
BuildRequires:  perl(Perl/Critic/PolicyParameter.pm)
BuildRequires:  perl(Perl/Critic/TestUtils.pm)
BuildRequires:  perl(Perl/Critic/UserProfile.pm)
BuildRequires:  perl(PPI/Document.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Perl/Critic.pm) >= 1.122
Source44: import.info

%description
The rules included with the Perl::Critic::Bangs group include:
  - Commented-out code is usually noise.  It should be removed.
  - Watch for comments like "XXX", "TODO", etc.
  - Tests should have a plan.
  - Variables like $user and $user2 are insufficiently distinguished.
  - Determining the class in a constructor by using "ref($proto) || $proto".
  - Adding modifiers to a regular expression made up entirely of a variable
  created with qr() is usually not doing what you expect.
  - Vague variables like $data or $info are not descriptive enough.

%prep
%setup -q -n Perl-Critic-Bangs-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README.md TODO
%{perl_vendor_privlib}/*

%changelog
