%define module_name Perl-Critic-Mardem
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(English.pm) perl(Exporter.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Path/This.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Perl/Critic/Utils/McCabe.pm) perl(Pod/Coverage.pm) perl(Readonly.pm) perl(Test/CheckManifest.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Tools/Exception.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Some Perl::Critic::Policies to search for needed refactoring
Group: Development/Perl
License: perl
URL: https://github.com/mardem1/perl-critic-mardem

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARDEM/Mardem-RefactoringPerlCriticPolicies-001targz/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Perl-Crictic Policy-Modules should help where to start a safe
refactoring in old leagacy Perl code.

The McCabe complexity check within the standard Perl-Critic Module are a good
overall starting point see:

=over 4

=item * the Perl::Critic::Policy::Modules::ProhibitExcessMainComplexity manpage

=item * the Perl::Critic::Policy::Subroutines::ProhibitExcessComplexity manpage

=back

but these are for some bigger scans, so these new policies should check (or begin) in smaller chunks:

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes LICENSE
%perl_vendor_privlib/P*

%changelog
