# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Perl/Critic.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Perl-Critic-Policy-BuiltinFunctions-ProhibitReturnOr
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Check for "return $x or ..."
Group: Development/Perl
License: perl
URL: https://github.com/ZipRecruiter/Perl-Critic-Policy-BuiltinFunctions-ProhibitReturnOr

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JL/JLEADER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`return' when encountered in an expression returns from the enclosing
subroutine, without evaluating the rest of the expression. So a
lower-precedence operator (`or', `and', `xor') won't get evaluated
after a `return'. This most commonly appears as the mis-idiom:

    # NO! DON'T DO THIS!
    return $x or die 'Aaaagh! $x was zero!';

Instead, use the higher-precedence `||' operator, like  this:

    return $x || die 'Aaaagh! $x was zero!';

Or separate the two operations, like this:

    $x or die 'Aaaagh! $x was zero!';
    return $x;


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/P*

%changelog
