%define module_name Perl-Critic-Policy-Moo-ProhibitMakeImmutable
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Moose.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(Test2/V0.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Makes sure that Moo classes do not contain calls to make_immutable.
Group: Development/Perl
License: perl
URL: https://github.com/bluefeet/Perl-Critic-Policy-Moo-ProhibitMakeImmutable

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUEFEET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
When migrating from the Moose manpage to the Moo manpage it can be a common issue to accidentally
leave in:

    __PACKAGE__->meta->make_immutable;

This policy complains if this exists in a Moo class as it triggers Moose to be
loaded and metaclass created, which defeats some of the benefits you get using
Moo instead of Moose.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/P*

%changelog
