# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Perl-Critic-Policy-Plicease-ProhibitArrayAssignAref
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 100.00
Release: alt1
Summary: Don't assign an anonymous arrayref to an array
Group: Development/Perl
License: gpl
URL: https://metacpan.org/pod/Perl::Critic::Policy::Plicease::ProhibitArrayAssignAref

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This policy is a fork of the Perl::Critic::Policy::ValuesAndExpressions::ProhibitArrayAssignAref manpage.
It differs from the original by not having a dependency on the List::MoreUtils manpage.
It is unfortunately still licensed as GPL3.

It asks you not to assign an anonymous arrayref to an array

    @array = [ 1, 2, 3 ];       # bad

The idea is that it's rather unclear whether an arrayref is intended, or
might have meant to be a list like

    @array = ( 1, 2, 3 );

This policy is under the "bugs" theme (see the POLICY THEMES entry in the Perl::Critic manpage)
for the chance `[]' is a mistake, and since even if it's correct it will
likely make anyone reading it wonder.

A single arrayref can still be assigned to an array, but with parens to make
it clear,

    @array = ( [1,2,3] );       # ok

Dereferences or array and hash slices (see the Slices entry in the perldata manpage) are
recognised as an array target and treated similarly,

    @$ref = [1,2,3];            # bad assign to deref
    @{$ref} = [1,2,3];          # bad assign to deref
    @x[1,2,3] = ['a','b','c'];  # bad assign to array slice
    @x{'a','b'} = [1,2];        # bad assign to hash slice

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README author.yml COPYING Changes
%perl_vendor_privlib/P*

%changelog
