%define module_name Perl-Critic-Policy-RegularExpressions-ProhibitEmptyAlternatives
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Carp.pm) perl(English.pm) perl(Module/Build.pm) perl(Module/Metadata.pm) perl(PPI/Document.pm) perl(PPIx/Regexp.pm) perl(Perl/Critic/Exception/Configuration/Option/Policy/ParameterValue.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/TestUtils.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(Test/More.pm) perl(Test/Perl/Critic/Policy.pm) perl(base.pm) perl(charnames.pm) perl(lib.pm) perl(open.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Beware empty alternatives, because they always match.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Perl::Critic policy checks for empty alternatives;
that is, things like `/a||b/'. The problem with these is that they
always match, which is very probably not what you want.

The possible exception is the final alternative, where you may indeed
want something like `/glass(?es|y|)/' to match `'glass'', `'glassy'',
or `'glasses'', though this is not the usual idiom. This policy does
not allow empty final alternatives by default, but it can be configured
to do so.

Note that empty alternatives are syntax errors in extended bracketed
character classes, so this policy treats them as violations no matter
how it is configured.

This policy was inspired by y's
https://github.com/Perl-Critic/Perl-Critic/issues/727.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/P*

%changelog
