%define module_name Perl-Critic-Policy-RegularExpressions-RequireDefault
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Pod/Coverage/TrustPod.pm) perl(Readonly.pm) perl(Test/CPAN/Changes.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/Fatal.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.02
Release: alt1
Summary: Always use the C</a> or C</aa> modifier with regular expressions.
Group: Development/Perl
License: artistic_2
URL: https://github.com/jonasbn/perl-critic-policy-regularexpressions-requiredefault

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JO/JONASBN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This poliy aims to help enforce using Perl's protective measures against security vulnerabilities related to Unicode, such as:

=over

=item * Visual Spoofing

=item * Character and String Transformation Vulnerabilities

=back

The `/a' and `/aa' modifiers standing for ASCII-restrict or ASCII-safe, provides protection for applications that do not need to be exposed to all of Unicode and possible security issues with Unicode.

`/a' causes the sequences `\d', `\s', `\w', and the Posix character classes to match only in the ASCII range. Meaning:

=over

=item * `\d' means the digits `0' to `9'

    my $ascii_letters =~ m/[A-Z]*/i;  # not ok
    my $ascii_letters =~ m/[A-Z]*/a;  # ok
    my $ascii_letters =~ m/[A-Z]*/aa; # ok

=item * `\s' means the five characters `[ \f\n\r\t]', and starting in Perl v5.18, also the vertical tab

    my $characters =~ m/[ \f\n\r\t]*/;   # not ok
    my $characters =~ m/[ \f\n\r\t]*/a;  # ok
    my $characters =~ m/[ \f\n\r\t]*/aa; # ok

=item * `\w' means the 63 characters `[A-Za-z0-9_]' and all the Posix classes such as `[[:print:]]' match only the appropriate ASCII-range characters

    my $letters =~ m/[A-Za-z0-9_]*/;   # not ok
    my $letters =~ m/[A-Za-z0-9_]*/a;  # ok
    my $letters =~ m/[A-Za-z0-9_]*/aa; # ok

=back

The policy also supports the pragma:

    use re 'a';

and:

    use re 'aa';

Which mean it will not evaluate the regular expressions any further:

    use re 'a';
    my $letters =~ m/[A-Za-z0-9_]*/;   # ok

Do note that the `/a' and `/aa' modifiers require Perl 5.14, so by using the recommended modifiers you indirectly introduct a requirement for Perl 5.14.

This policy is inspired by Perl::Critic::Policy::RegularExpressions::RequireExtendedFormatting and many implementation details was lifted from this particular distribution.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md LICENSE Changes README CODE_OF_CONDUCT.md
%perl_vendor_privlib/P*

%changelog
