%define module_name Perl-Critic-Policy-TryTiny-RequireBlockTermination
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(Test2/V0.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Requires that try/catch/finally blocks are properly terminated.
Group: Development/Perl
License: perl
URL: https://github.com/bluefeet/Perl-Critic-Policy-TryTiny-RequireBlockTermination

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUEFEET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A common problem with the Try::Tiny manpage is forgetting to put a semicolon after the
try/catch/finally block which can lead to difficul to debug issues.  While
the Try::Tiny manpage does do its best to detect this issue it cannot if the code after
the block returns an empty list.

For example, this will fail:

    try { } catch { }
    my $foo = 2;

Since the `my $foo=2' returns `2' and `try' throws an exception that an
unexpected argument was passed.

But this will not fail:

    try { } catch { }
    grep { ... } @some_empty_list;

With the above the code after the try blocks produces an empty list.  Lots of
different things produce empty lists.  When this happens the code after the try
blocks is executed BEFORE the try blocks are executed since they are evaluated
as arguments to the try function!

And this also does not fail:

    try { } catch { }
    return()

Flow control logic after the try blocks will execute before the try blocks are executed
for the same reason as the previous example.

There is one situation (that the author is aware of) where non-terminated try blocks
makes sense.

    try { } catch { } if ...;

In this case the code will run as expected, the if, when evaluating to true, will
cause the try blocks to be run, and if false they will not be run.  Despite this
working this module fails on it.  If this is something that you think is important
to support the author is happy to accept requests and patches.

Note that this policy should be just as useful with other similar modules such as
the Try::Catch manpage and the TryCatch manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/P*

%changelog
