%define module_name Perl-Critic-Policy-TryTiny-RequireUse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(Test2/V0.pm) perl(Try/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Requires that code which utilizes Try::Tiny actually use()es it.
Group: Development/Perl
License: perl
URL: https://github.com/bluefeet/Perl-Critic-Policy-TryTiny-RequireUse

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUEFEET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A common problem with the Try::Tiny manpage is forgetting to use the module in the first
place.  For example:

    perl -e 'try { print "hello" } catch { print "world" }'
    Can't call method "catch" without a package or object reference at -e line 1.
    helloworld

If you forget this then both code blocks will be run and an exception will be thrown.
While this seems like a rare issue, when I first implemented this policy I found
several cases of this issue in real live code and due to layers of exception handling
it had gotten lost and nobody realized that there was a bug happening due to the missing
use statements.

This policy is OK if you use the Error manpage, the Syntax::Feature::Try manpage, the Try manpage, the Try::Catch manpage,
and the TryCatch manpage modules which also export the `try' function.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/P*

%changelog
