# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Perl/Critic.pm) perl(Test/CPAN/Meta.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.004
%define module_name Perl-Critic-Policy-ValuesAndExpressions-ProhibitSingleArgArraySlice
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Prohibit using an array slice with only one index
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/X/XS/XSAWYERX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
When using an array slice `@foo[]', you can retrieve multiple values by
giving more than one index. Sometimes, however, either due to typo or
inexperience, we might only provide a single index.

Perl warns you about this, but it will only do this during runtime. This
policy allows you to detect it statically.

  # scalar context, single value retrieved
  my $one_value = $array[$index];            # ok

  # List context, multiple values retrieved
  my @values    = @array[ $index1, $index2 ] # ok

  # Scalar context, single value retrived (the last item in the array)
  # Perl will warn you, but only in runtime
  my $value     = @array[$index];            # not ok
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/P*

%changelog
