# BEGIN SourceDeps(oneline):
BuildRequires: perl(File/Spec.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Perl/Critic.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Perl-Critic-Policy-Variables-NameReuse
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Don't reuse names for different types of variables
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Perl-Critic-Policy-Variables-NameReuse

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This policy checks for the existence of multiple variables with the same name
in a file. This can be confusing especially when accessing elements of
variables or using list or key-value slices. For example,
the code could access both `$foo' and `$foo[0]' but these actually refer to
the unrelated variables `$foo' and `@foo'.

  my $foo = @foo;             # not ok
  my @bar = @bar{'a','b'};    # not ok
  my $count = @foo;           # ok
  my @values = @bar{'a','b'}; # ok

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CONTRIBUTING.md LICENSE Changes
%perl_vendor_privlib/P*

%changelog
