%define module_name Perl-LanguageServer
%set_perl_req_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/AIO.pm) perl(Class/Refresh.pm) perl(Compiler/Lexer.pm) perl(Coro.pm) perl(Data/Dump.pm) perl(Encode.pm) perl(Encode/Locale.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/SafeKeys.pm) perl(IO/AIO.pm) perl(JSON.pm) perl(Moose.pm) perl(PadWalker.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.6.2
Release: alt1
Summary: Language Server for Perl
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRICHTER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a Language Server for Perl

It implements the Language Server Protocol which provides
syntax-checking, symbol search, etc. Perl to various editors, for
example Visual Stuido Code or Atom.

https://microsoft.github.io/language-server-protocol/specification

To use it with Visual Studio Code, install the extention "perl"

This is an early version, but already working version.
Any comments and patches are welcome.

NOTE: This module uses Compiler::Lexer. The version on cpan (0.22) is buggy
crashes from time to time. Please use the version from github 
(https://github.com/goccy/p5-Compiler-Lexer) until
a new version is published to cpan.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.pod Changes.pod
%perl_vendor_privlib/P*

%changelog
