%define module_name Perl-LineNumber-Comment
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(PPI/Document.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Add line number to Perl source as comment
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Perl-LineNumber-Comment

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Perl::LineNumber::Comment qw(add_line_number_comments_to_perl_source);
 print add_line_number_comments_to_perl_source(<<'EOF');
 #!/usr/bin/env perl

 use 5.010001;
 use strict;
 use warnings;

 print "Hello, world 1!";
 print "Hello, world 2!";                   # a comment
 print "A multiline
 string";

 print <<EOF2;
 A heredoc (not shown in node->content).

 Line three.
 EOF2

 exit 0;

 __END__
 one
 two
 three
 EOF

will print:

 #!/usr/bin/env perl

 use 5.010001;
 use strict;
 use warnings; # line 5

 print "Hello, world 1!";
 print "Hello, world 2!";                   # a comment
 print "A multiline
 string"; # line 10

 print <<EOF;

 exit 0;

 __END__
 one
 two
 three

=for Pod::Coverage ^(.+)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/P*

%changelog
