# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Perl-Unsafe-Signals
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt6
Summary: Allow unsafe handling of signals in selected blocks
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RG/RGARCIA/%{module_name}-%{module_version}.tar.gz

%description
Quoting the perl581delta manpage:

*In Perl 5.8.0 the so-called "safe signals" were introduced.  This
means that Perl no longer handles signals immediately but instead
"between opcodes", when it is safe to do so.  The earlier immediate
handling easily could corrupt the internal state of Perl, resulting
in mysterious crashes.*

It's possible since perl 5.8.1 to globally disable this feature by using
the `PERL_SIGNALS' environment variables (as specified in
the PERL_SIGNALS entry in the perlrun manpage); but there's no way to disable it locally, for a
short period of time. That's however something you might want to do,
if, for example, your Perl program calls a C routine that will potentially
run for a long time and for which you want to set a timeout.

This module therefore allows you to define `UNSAFE_SIGNALS' blocks
in which signals will be handled "unsafely".

Note that, no matter how short you make the unsafe block, it will still
be unsafe. Use with caution.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/P*
%perl_vendor_autolib/*

%changelog
