%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Attribute/Handlers.pm) perl(ExtUtils/MakeMaker.pm) perl(Filter/Simple.pm) perl(Test/Simple.pm) perl(YAML.pm) perl(charnames.pm) perl(overload.pm) perl(re.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Perl6-Rules
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Implements (most of) the Perl 6 regex syntax
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DC/DCONWAY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module implements a close simulation of the Perl 6 rule and grammar
constructs, translating them back to Perl 5 regexes via a source filter.
(And hence suffers from all the usual limitations of a source filter,
including the ability to translate complex code spectacularly wrongly).

See the LIMITATIONS manpage for a summary of those features that are not
currently supported.

When it is `use''d, the module expects that any subsequent match (`m/.../')
or substitution (`s/.../.../') in the rest of the source file will be in
Perl 6 syntax. It then translates every such pattern back to the equivalent
Perl 5 syntax (where possible).

When one of these translated matches/substitutions is executed, it
generates a "match object", which is available as `$0' (and so, if you
use Perl6::Rules, the program name is no longer available as `$0').
This match object can be treated as a boolean (in which case it returns
true if the match succeeded, and false if it did not), or as a string
(in which case it returns the complete substring that the match
matched), or as an array (in which case it contains all of the numbered
captures -- `$1', `$2', etc. -- from the successful match), or as a
hash (in which case it contains all of the internal variables created during the match).



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
