# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Error.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(Test.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.0
%define module_name PerlBean
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Package to generate bean like Perl modules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZO/ZOCCAV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The `PerlBean' class models a Perl module with one package. After adding different components to the `PerlBean', the Perl module can be generated..
The following sections in the code generated by a `PerlBean' are used to explain the concept.

=over

=item `PerlBean' module file header section

 package Circle;
 
 use 5.008;
 use base qw( Shape Exporter );
 use strict;
 use warnings;
 use Error qw(:try);
 require Exporter;

=over

=item `set_package()'

is used to set the package name in `package Circle'.

=item `add_dependency()' or `set_dependency()'

are used to add `PerlBean::Dependency' objects like the `use' and `require' lines in the example. Note however that except for `use base' all `use' dependencies in the example above are set by default when initializing a `PerlBean' object without specifying a `dependency' option.

=item `set_use_perl_version()'

is used to set the version number in the `use 5.008' dependency. By default the version number is set to `\$]'. This is an exception to the `PerlBean::Dependency' mechanism.

=item `push_base()', `set_base()' or `unshift_base()'

are used to express inheritance relationships. When the `PerlBean' is written, the inheritance relationships -like `Shape' in this example- appear in the `use base' list. The `Exporter' bit is there because symbols are exported by `package Circle'.

=back

=item `PerlBean' symbols:

=over

=item `add_symbol()' or `set_symbol()'

are used to add `PerlBean::Symbol' objects. `PerlBean::Symbol' objects are described in their own manual pages.

=back

=item `PerlBean' complimentary symbols:

 # Used by _value_is_allowed
 our %%ALLOW_ISA = (
 );
 
 # Used by _value_is_allowed
 our %%ALLOW_REF = (
 );
 
 # Used by _value_is_allowed
 our %%ALLOW_RX = (
     'radius' => [ '^\d*(\.\d+)?$' ],
 );

 # Used by _value_is_allowed
 our %%ALLOW_VALUE = (
 );
 
 # Used by _initialize
 our %%DEFAULT_VALUE = (
 );

 # Package version
 our ($VERSION) = '$Revision: 1.0 $' =~ /\$Revision:\s+([^\s]+)/;

The `our %%ALLOW.*' symbols above are used by the generated class to check rules that apply to the `PerlBean''s attributes. They are not exported. You could theoretically overwrite them. But don't do that!

The `our %%DEFAULT_VALUE' symbol above is used at class instantiation to set the attribute's default values of the `PerlBean'. It is not exported. Sometimes you need to overwrite values. That's not particularly nice and should be addressed.

The `our ($VERSION)' is there to allow versioning through CVS. You could overwrite it.

=item Preloaded section end

 1;
 
 __END__

If the `PerlBean' is `autoloaded' then the code above is generated in order to autoload the methods that follow. The method `set_autoloaded()' is used to change the autoload behavior of a `PerlBean'. NOTE: In my experience it pays to first have `PerlBean's preloaded and to switch to autoload after debugging.

=item NAME section

 
%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes TODO COPYING
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*
%changelog
