%define module_name PerlIO-via-EscStatus
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/FindRef.pm) perl(Devel/TraceLoad.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Coda.pm) perl(IO/String.pm) perl(PerlIO/via.pm) perl(ProgressMonitor.pm) perl(ProgressMonitor/SetMessageFlags.pm) perl(ProgressMonitor/State.pm) perl(ProgressMonitor/Stringify/Fields/Counter.pm) perl(ProgressMonitor/Stringify/Fields/Fixed.pm) perl(ProgressMonitor/Stringify/Fields/Spinner.pm) perl(ProgressMonitor/Stringify/ToStream.pm) perl(Regexp/Common.pm) perl(Regexp/Common/ANSIescape.pm) perl(Term/Cap.pm) perl(Term/Size.pm) perl(Term/Sk.pm) perl(Unicode/Normalize.pm) perl(charnames.pm) perl(classes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 12
Release: alt1
Summary: Printing a status line through an I/O layer.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/perlio-via-escstatus/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
An EscStatus layer prints and reprints a status line using carriage returns
and backspaces for a dumb terminal.  This is meant as a progress or status
display in a command line program.

    Working ... record 20 of 80 (25%%)
                                     ^--cursor left here

Status lines are communicated to EscStatus "in band" in the output stream
using an escape sequence.  Currently this is an ANSI "APC" application
control followed by the status line.  `make_status()' and `print_status()'
below produce this.

    "\e_EscStatus\e\\Status string\n"

The layer clears and redraws the status when ordinary output text is printed
so it appears as normal.  The status is also erased when the layer is
popped, though unfortunately not when the stream is closed (see the BUGS entry elsewhere in this document
below).

See examples/demo.pl in the PerlIO-via-EscStatus sources for a simple
complete program.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes COPYING examples
%perl_vendor_privlib/P*

%changelog
